"use strict";
(() => {
var exports = {};
exports.id = 39;
exports.ids = [39];
exports.modules = {

/***/ 1738:
/***/ ((module) => {

module.exports = require("multer");

/***/ }),

/***/ 5616:
/***/ ((module) => {

module.exports = import("next-connect");;

/***/ }),

/***/ 4498:
/***/ ((module) => {

module.exports = import("pdf2json");;

/***/ }),

/***/ 8712:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   config: () => (/* binding */ config),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var next_connect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5616);
/* harmony import */ var multer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1738);
/* harmony import */ var multer__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(multer__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Utils_aiPdfHandler__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(323);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([next_connect__WEBPACK_IMPORTED_MODULE_0__, _Utils_aiPdfHandler__WEBPACK_IMPORTED_MODULE_2__]);
([next_connect__WEBPACK_IMPORTED_MODULE_0__, _Utils_aiPdfHandler__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
/**
 * External dependencies
 */ 

/**
 * Internal dependencies
 */ 
const upload = multer__WEBPACK_IMPORTED_MODULE_1___default()({
    storage: multer__WEBPACK_IMPORTED_MODULE_1___default().memoryStorage()
});
const uploadMiddleware = upload.single("pdf");
const handler = (0,next_connect__WEBPACK_IMPORTED_MODULE_0__["default"])();
handler.use(uploadMiddleware);
handler.post(async (req, res)=>{
    try {
        if (!req.file) {
            throw new Error("No file received");
        }
        // Get the schema from the formData
        const schema = JSON.parse(req.body.schema);
        const aiResponse = await (0,_Utils_aiPdfHandler__WEBPACK_IMPORTED_MODULE_2__/* .aiPdfHandler */ .v)(req.file.buffer, schema);
        res.status(200).json({
            fileName: req.file.originalname,
            data: aiResponse
        });
    } catch (error) {
        res.status(500).json({
            error: error.message
        });
    }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (handler);
const config = {
    api: {
        bodyParser: false
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 323:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   v: () => (/* binding */ aiPdfHandler)
/* harmony export */ });
/* harmony import */ var _pdf__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8960);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_pdf__WEBPACK_IMPORTED_MODULE_0__]);
_pdf__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
/**
 * EXTERNAL-DEPENDENCIES
 */ 
const aiPdfHandler = async (fileBuffer, schema)=>{
    // images
    try {
        const imageUrls = await (0,_pdf__WEBPACK_IMPORTED_MODULE_0__/* .extractImagesFromPdf */ .pY)(fileBuffer); // Extract images using the above function
        console.log(imageUrls);
    } catch (error) {
        console.error("Error extracting images:", error);
    }
    // raw holder info
    return (0,_pdf__WEBPACK_IMPORTED_MODULE_0__/* .parsePdfWithPdf2json */ .IU)(fileBuffer).catch((error)=>{
        console.error("Error parsing with pdf2json:", error);
    }).then((pdfData)=>{
        console.log("PDF Data from pdf2json:", pdfData);
        return pdfData;
    });
// 	//sam return documentText;
// 	// const schemaToUse = schema || sample_schema;
// 	const prompts = buildPromptArray(documentText, schemaToUse);
// 	// const aiResponsesPromises = prompts
// 	// 	.map(subPrompt => {
// 	// 		if (subPrompt.prompt) {
// 	// 			return createChatCompletion(openai, subPrompt);
// 	// 		}
// 	// 	})
// 	// 	.filter(promise => promise !== undefined);
// 	// const completedPromptObjects = await Promise.all(aiResponsesPromises);
// 	// const resultObjectArr = completedPromptObjects.map(completedPromptObj => {
// 	// 	if (completedPromptObj?.output) {
// 	// 		return generateJsonObject(completedPromptObj);
// 	// 	}
// 	// });
// 	// return zipObjects(resultObjectArr);
// } catch (error: any) {
// 	console.error(error);
// 	throw new Error(error);
// }
};
const zipObjects = (aiResponse)=>{
    return Object.assign({}, ...aiResponse);
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8960:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IU: () => (/* binding */ parsePdfWithPdf2json),
/* harmony export */   pY: () => (/* binding */ extractImagesFromPdf)
/* harmony export */ });
/* unused harmony export extractText */
/* harmony import */ var pdf2json__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4498);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([pdf2json__WEBPACK_IMPORTED_MODULE_0__]);
pdf2json__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
/**
 * LOCAL-DEPENDENCIES
 */ 
/**
 * FUNCTIONS
 */ async function parsePdfWithPdf2json(buffer) {
    return new Promise((resolve, reject)=>{
        const pdfParser = new pdf2json__WEBPACK_IMPORTED_MODULE_0__["default"](null, true);
        // Listen for error from pdf2json
        pdfParser.on("pdfParser_dataError", (error)=>{
            reject(error);
        });
        // Listen for the parsed data from pdf2json
        pdfParser.on("pdfParser_dataReady", (pdfData)=>{
            console.log("META = ", pdfData.Meta);
            console.log("Number of Texts = ", pdfData.Pages[0].Texts.length);
            resolve(extractIdInfo(pdfData));
        });
        // Convert Buffer to ArrayBuffer
        //const arrayBuffer = buffer.buffer.slice(buffer.byteOffset, buffer.byteOffset + buffer.byteLength);
        // Start parsing from the ArrayBuffer
        pdfParser.parseBuffer(buffer);
    });
}
function extractIdInfo(pdfData) {
    const pageData = pdfData.Pages[0];
    const texts = pageData.Texts;
    const cardInfo = {
        fcn: "",
        full_name: "",
        full_name_am: "",
        date_of_birth: "",
        date_of_birth_am: "",
        region: "",
        region_am: "",
        gender: "",
        gender_am: "",
        subcity_zone: "",
        subcity_zone_am: "",
        nationality: "",
        nationality_am: "",
        woreda: "",
        woreda_am: "",
        phone_number: ""
    };
    texts.map((text, index)=>{
        const fieldValue = decodeURIComponent(text.R[0].T);
        switch(index){
            case 82:
                cardInfo.date_of_birth_am = fieldValue;
                break;
            case 83:
                cardInfo.date_of_birth = fieldValue;
                break;
            case 84:
                cardInfo.gender_am = fieldValue;
                break;
            case 85:
                cardInfo.gender = fieldValue;
                break;
            case 86:
                cardInfo.nationality_am = fieldValue;
                break;
            case 87:
                cardInfo.nationality = fieldValue;
                break;
            case 88:
                cardInfo.phone_number = fieldValue;
                break;
            case 89:
                cardInfo.region_am = fieldValue;
                break;
            case 90:
                cardInfo.region = fieldValue;
                break;
            case 91:
                cardInfo.subcity_zone_am = fieldValue;
                break;
            case 92:
                cardInfo.subcity_zone = fieldValue;
                break;
            case 93:
                cardInfo.woreda_am = fieldValue;
                break;
            case 94:
                cardInfo.woreda = fieldValue;
                break;
            case 95:
                cardInfo.fcn = fieldValue;
                break;
            case 96:
                cardInfo.full_name_am = fieldValue;
                break;
            case 97:
                cardInfo.full_name = fieldValue;
                break;
            default:
                break;
        }
    });
    return cardInfo;
}
// Function to extract images from the PDF buffer
async function extractImagesFromPdf(buffer) {
    const imageUrls = [];
    // Export via EventEmitter
    // exportImagesEvents('file.pdf', 'output/dir')
    // 	.on('load', event => console.log('Exporting images from', event.pageCount, 'pages...'))
    // 	.on('image', ({ file, width, height }) => console.log(file, `(${width}x${height})`))
    // 	.on('error', console.error)
    // 	.on('done', images => console.log(images.length, 'images exported'))
    // 	.catch(console.error)
    // const pdfDoc = await PDFDocument.load(buffer);
    // for (const page of pdfDoc.getPages()) {
    // 	const res = page.node.Resources;
    // 	page.node.Resources.call((xobjects: any) => {
    // 		console.log(xobjects);
    // 		if (xobjects) {
    // 			const xObjectKeys = Object.keys(xobjects);
    // 			for (const key of xObjectKeys) {
    // 				const xObject = xobjects[key];
    // 				const xObjectStream = xObject.getContents(); // Extract the raw stream
    // 				// Decode the stream based on the image type
    // 				if (xObjectStream) {
    // 					const imageBytes = xObjectStream;
    // 					const imageBase64 = Buffer.from(imageBytes).toString('base64'); // Convert to Base64
    // 					const mimeType = 'image/png'; // You might need to detect the type properly
    // 					// Create data URL for embedding in <img> tags
    // 					const imageUrl = `data:${mimeType};base64,${imageBase64}`;
    // 					imageUrls.push(imageUrl);
    // 				}
    // 			}
    // 		}
    // 	});
    // }
    return imageUrls;
}
// Extracts the text from the Buffer object of the PDF and returns a string
const extractText = async (dataBuffer, func)=>{
    const pdfData = await pdfParse(dataBuffer);
    // let extractedText: string = pdfData.text;
    // const tokenCount = countTokens(extractedText);
    // if (tokenCount > 3000) {
    // 	throw new Error(
    // 		`Your PDF file has too much text to process (about ${tokenCount} tokens). Please use a file with less text.`,
    // 	);
    // }
    //SAM//
    const parser = new PDFParser();
    parser.on("pdfParser_dataError", (errData)=>console.error(errData.parserError));
    const retured = parser.on("pdfParser_dataReady", (pdfData)=>{});
    parser.parseBuffer(dataBuffer);
    //SAM//
    return retured;
};
const countTokens = (text)=>{
    const whitespaceRegex = /\s+/g;
    const tokenRegex = /[\p{L}\p{N}]+|[\p{P}\p{S}]+/gu;
    const cleanedText = text.replace(whitespaceRegex, " ").trim();
    const tokens = cleanedText.match(tokenRegex) || [];
    return tokens.length;
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../webpack-api-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = (__webpack_exec__(8712));
module.exports = __webpack_exports__;

})();